/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.pickup;

import java.util.function.Consumer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IPickupResponseUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.ContentsFilterLogic;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.IContentsFilteredUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.pickup.PickupUpgradeItem;
import net.p3pp3rf1y.sophisticatedbackpacks.util.InventoryHelper;

public class PickupUpgradeWrapper
extends UpgradeWrapperBase<PickupUpgradeWrapper, PickupUpgradeItem>
implements IPickupResponseUpgrade,
IContentsFilteredUpgrade {
    private static final int BACKPACK_FILTER_REFRESH_COOLDOWN_TICKS = 10;
    private static final int FULL_COOLDOWN = 60;
    private final ContentsFilterLogic filterLogic;
    private long backpackContentsRefreshCooldown = 0L;

    public PickupUpgradeWrapper(IBackpackWrapper backpackWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(backpackWrapper, upgrade, upgradeSaveHandler);
        this.filterLogic = new ContentsFilterLogic(upgrade, stack -> this.save(), ((PickupUpgradeItem)this.upgradeItem).getFilterSlotCount());
    }

    @Override
    public ItemStack pickup(World world, ItemStack stack, boolean simulate) {
        ItemStack ret;
        if (this.isInCooldown(world)) {
            return stack;
        }
        if (this.backpackContentsRefreshCooldown < world.func_82737_E()) {
            this.backpackContentsRefreshCooldown = world.func_82737_E() + 10L;
            this.filterLogic.refreshBackpackFilterStacks((IItemHandler)this.backpackWrapper.getInventoryForUpgradeProcessing());
        }
        if (!this.filterLogic.matchesFilter(stack)) {
            return stack;
        }
        int originalCount = stack.func_190916_E();
        if (originalCount == (ret = InventoryHelper.insertIntoInventory(stack, (IItemHandler)this.backpackWrapper.getInventoryForUpgradeProcessing(), simulate)).func_190916_E()) {
            this.setCooldown(world, 60);
        }
        return ret;
    }

    @Override
    public ContentsFilterLogic getFilterLogic() {
        return this.filterLogic;
    }
}

